package org.opensha.sra.vulnerability.models;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.LineNumberReader;
import java.util.ArrayList;
import java.util.StringTokenizer;

import org.opensha.sra.vulnerability.Vulnerability;

import com.google.common.base.Preconditions;

public class VulnFileReader {
	
	public static ArrayList<SimpleVulnerability> readVUL06File(InputStream fileInput) throws IOException {
		LineNumberReader in = new LineNumberReader(new InputStreamReader(fileInput));
		
		String line = in.readLine();
		
		StringTokenizer tok;
		// these vals get overwritten with each line
		String vulnID, abbr = null, displayName = null, height, matCat, lfrs, dl, occ, lossType, imt = null;
		
		// these represent the "current" vuln function
		String curVulnID = null;
		ArrayList<Double> curIMLVals = new ArrayList<Double>();
		ArrayList<Double> curMDFVals = new ArrayList<Double>();
		ArrayList<Double> curCOVFunc = new ArrayList<Double>();
		
		ArrayList<SimpleVulnerability> vulns = new ArrayList<SimpleVulnerability>();
		
		// read the file
		while(line != null) {
			// we skip the first two (header) lines
			if (in.getLineNumber() < 3) {
				line = in.readLine();
				continue;
			}
			
			if (line.trim().length() == 0)
				continue;
			
			tok = new StringTokenizer(line, ",");
			
			tok.nextToken(); // row number
			vulnID = tok.nextToken(); // vuln id
			
			if (curVulnID == null) {
				// this is the first time though
				curVulnID = vulnID;
			} else if (!curVulnID.equals(vulnID)) {
				// we just finished a vuln func
				double period = 0;
				if (imt.startsWith("SA") && imt.length() > 2) {
					period = Double.parseDouble(imt.substring(2)) / 10d;
					imt = imt.substring(0, 2);
				}
				SimpleVulnerability vuln =
					new SimpleVulnerability(displayName, abbr, imt, curIMLVals, curMDFVals, curCOVFunc);
				vuln.setPeriod(period);
				vulns.add(vuln);
				
				curIMLVals = new ArrayList<Double>();
				curMDFVals = new ArrayList<Double>();
				curCOVFunc = new ArrayList<Double>();
				
				curVulnID = vulnID;
			}
			
			abbr = tok.nextToken(); // vuln abbr
			displayName = tok.nextToken(); // dispaly name
			if (displayName.length() == 0 || displayName.equals("*"))
				displayName = abbr;
			height = tok.nextToken(); // height
			matCat = tok.nextToken(); // material category
			lfrs = tok.nextToken(); // lateral force resisting system
			dl = tok.nextToken(); // design level
			occ = tok.nextToken(); // occupancy category
			lossType = tok.nextToken(); // loss type
			imt = tok.nextToken(); // intensity measure type
			double iml = Double.parseDouble(tok.nextToken()); // intensity measure level
			if (curIMLVals.contains(iml))
				throw new IllegalStateException("Duplicate IMLs found for vuln " + vulnID + ", " + abbr + ". IML: " + iml);
			curIMLVals.add(iml);
			curMDFVals.add(Double.parseDouble(tok.nextToken())); // mean value of loss
			curCOVFunc.add(Double.parseDouble(tok.nextToken())); // coefficient of variation
			
			line = in.readLine();
		}
		
		if (curIMLVals.size() > 0) {
			double period = 0;
			if (imt.startsWith("SA") && imt.length() > 2) {
				period = Double.parseDouble(imt.substring(2)) / 10d;
				imt = imt.substring(0, 2);
			}
			SimpleVulnerability vuln =
				new SimpleVulnerability(displayName, abbr, imt, curIMLVals, curMDFVals, curCOVFunc);
			vuln.setPeriod(period);
			vulns.add(vuln);
		}
		
		return vulns;
	}

	/**
	 * @param args
	 * @throws IOException 
	 */
	public static void main(String[] args) throws IOException {
//		File file = new File("/tmp/small_vuln.txt");
//		FileInputStream file = new FileInputStream("/home/kevin/OpenSHA/openSRA/vuln/2010_02_23_vulns.txt");
		FileInputStream file = new FileInputStream("/home/kevin/OpenSHA/portfolio_lec/2014_05_16b_VUL06.txt");
		
		long start = System.currentTimeMillis();
		ArrayList<SimpleVulnerability> vulns = readVUL06File(file);
		long end = System.currentTimeMillis();
		
		System.out.println("total time: " + ((end - start) / 1000d) + " secs");
		
		System.out.println("vulns: " + vulns.size());
		for (int i=0; i<3; i++) {
			Vulnerability vuln = vulns.get(i);
			System.out.println();
		}
	}

}
