package org.opensha.sra.vulnerability;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;

import org.opensha.sra.vulnerability.models.SimpleVulnerability;
import org.opensha.sra.vulnerability.models.VulnFileReader;
import org.opensha.sra.vulnerability.models.curee.caltech.CCLargeHouseImmediateOccupancy;
import org.opensha.sra.vulnerability.models.curee.caltech.CCLargeHouseRigidDiaphram;
import org.opensha.sra.vulnerability.models.curee.caltech.CCLargeHouseTypical;
import org.opensha.sra.vulnerability.models.curee.caltech.CCLargeHouseWaistWall;
import org.opensha.sra.vulnerability.models.curee.caltech.CCSmallHouseRetro;
import org.opensha.sra.vulnerability.models.curee.caltech.CCSmallHouseTypical;
import org.opensha.sra.vulnerability.models.curee.caltech.CCTownhouseLimitedDrift;
import org.opensha.sra.vulnerability.models.curee.caltech.CCTownhouseTypical;
import org.opensha.sra.vulnerability.models.servlet.VulnerabilityServletAccessor;

import com.google.common.base.Preconditions;

public class VulnerabilityFetcher {
	
private static HashMap<String, Vulnerability> vulnerabilities;
	
	public static HashMap<String, Vulnerability> getVulnerabilities() {
		return getVulnerabilities(null);
	}
	
	public static synchronized HashMap<String, Vulnerability> getVulnerabilities(File file) {
		if (vulnerabilities == null) {
			vulnerabilities = new HashMap<String, Vulnerability>();
			Vulnerability vuln;
			
			vuln = new CCLargeHouseImmediateOccupancy();
			vulnerabilities.put(vuln.getShortName(), vuln);
			
			vuln = new CCLargeHouseRigidDiaphram();
			vulnerabilities.put(vuln.getShortName(), vuln);
			
			vuln = new CCLargeHouseTypical();
			vulnerabilities.put(vuln.getShortName(), vuln);
			
			vuln = new CCLargeHouseWaistWall();
			vulnerabilities.put(vuln.getShortName(), vuln);
			
			vuln = new CCSmallHouseRetro();
			vulnerabilities.put(vuln.getShortName(), vuln);
			
			vuln = new CCSmallHouseTypical();
			vulnerabilities.put(vuln.getShortName(), vuln);
			
			vuln = new CCTownhouseLimitedDrift();
			vulnerabilities.put(vuln.getShortName(), vuln);
			
			vuln = new CCTownhouseTypical();
			vulnerabilities.put(vuln.getShortName(), vuln);
			
			//String fileName = "/Users/emartinez/Desktop/2010_02_23_vulns.txt";
//			String fileName = "/resources/data/vulnerability_20100223_keith.txt";
//			File file = new File(fileName);
			InputStream vulnFileInput = null;
			
			if (file != null && file.exists()) {
				try {
					vulnFileInput = new FileInputStream(file);
				} catch (IOException iox) {
					iox.printStackTrace(System.err);
				}
			}
			
			try {
				ArrayList<SimpleVulnerability> fileVulns = VulnFileReader.readVUL06File(vulnFileInput);
				System.out.println("Loaded " + fileVulns.size() + " vulns from " + file.getAbsolutePath());
				for (SimpleVulnerability sVuln : fileVulns) {
					vulnerabilities.put(sVuln.getShortName(), sVuln);
				}
			} catch (Exception e) {
				// TODO Auto-generated catch block
//				e.printStackTrace();
				System.out.println("Loading vulnerabilities from Servlet!");
				VulnerabilityServletAccessor accessor = new VulnerabilityServletAccessor();
				try {
					HashMap<String, Vulnerability> map = accessor.getVulnMap();
					for (String shortName : map.keySet()) {
						vulnerabilities.put(shortName, map.get(shortName));
					}
				} catch (IOException e1) {
					// TODO Auto-generated catch block
					e.printStackTrace();
					e1.printStackTrace();
					System.out.println("couldn't get vulnerabilities from file or servlet!");
				}
			}
			System.out.println("Added " + vulnerabilities.size() + " vulnerabilities!");
		} else {
			Preconditions.checkState(file == null, "Vulnerabilities were already loaded, can't yet call later with a file");
		}
		
		return vulnerabilities;
	}

}
