package org.opensha.sra.vulnerability.models.servlet;

import java.io.FileInputStream;
import java.io.IOException;
import java.util.HashMap;
import java.util.Set;

import org.opensha.sra.vulnerability.Vulnerability;
import org.opensha.sra.vulnerability.models.VulnFileReader;
import org.opensha.sra.vulnerability.models.SimpleVulnerability;

/**
 * This provides a way to use a local file to retrieve vulnerabilities instead 
 * the servlet. 
 * Maintains the same class structure as VulnerabilityServletAccessor.
 * Useful for local testing.
 * 
 * @author anne
 *
 */
public class VulnerabilityLocalAccessor
        extends VulnerabilityServletAccessor {

    private HashMap<String, Vulnerability> localVulns;

    public VulnerabilityLocalAccessor() throws IOException {
        load();
    }

    private void load() throws IOException {
        FileInputStream in = new FileInputStream(
            "C:/Users/ahulsey/OneDrive - DOI/Desktop/Research/vulnerabilities/" +
            "borrowed_vulnerabilities/Porter_Hazus-and-Curee/from Kevin/" +
            "porter_portfolios_and_vulns/2014_05_16b_VUL06.txt"
        );

        localVulns = new HashMap<>();

        for (SimpleVulnerability v :
                VulnFileReader.readVUL06File(in)) {
            localVulns.put(v.getName(), v);
        }
    }

    @Override
    public HashMap<String, Vulnerability> getVulnMap() {
        return localVulns;
    }

    @Override
    public Vulnerability getVuln(String name) {
        return localVulns.get(name);
    }

    @Override
    public Set<String> getNames() {
        return localVulns.keySet();
    }
    
	public static void main(String args[]) throws IOException {
		VulnerabilityServletAccessor vulns = new VulnerabilityLocalAccessor();
		
		Vulnerability vuln = vulns.getVuln("C1H-h-AGR1-DF");
		System.out.println("Got vuln:");
		System.out.println(vuln);
		
	}
}
