package org.opensha.sra.vulnerability.models.curee.caltech;

/**
 * <strong>Title:</strong> CCLageHouseWaistWall<br />
 * <strong>Description</strong> A digital representation of the CUREE-Caltech Woodframe
 * Project large house waist wall Sagm(0.2s,5%) vulnerability function. (CWF-204-0205)
 * 
 * @see CureeCaltechWoodFrame
 * @author <a href="mailto:emartinez@usgs.gov">Eric Martinez</a>
 * @author Keith Porter
 *
 */
public class CCLargeHouseWaistWall extends CureeCaltechWoodFrame {
	
	private static double [] DF = {
		0.000, 0.000, 0.000, 0.000, 0.002, 0.007, 0.017, 0.026, 0.034, 0.040, 
		0.046, 0.052, 0.057, 0.062, 0.066, 0.070, 0.074, 0.077, 0.081, 0.084
	};
	
	private static double[] COVDF = {
		2.50, 2.50, 2.50, 2.50, 1.53, 1.05, 0.84, 0.75, 0.70, 0.67,
		0.64, 0.62, 0.61, 0.59, 0.58, 0.57, 0.56, 0.56, 0.55, 0.55
	};
	
	private static double[][] DEM = {
		{0.00E+000, 0.00E+000, 0.00E+000, 0.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000},
		{0.00E+000, 0.00E+000, 0.00E+000, 0.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000},
		{0.00E+000, 0.00E+000, 0.00E+000, 0.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000},
		{0.00E+000, 0.00E+000, 0.00E+000, 0.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000},
		{0.00E+000, 0.00E+000, 0.00E+000, 0.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000},
		{0.00E+000, 0.00E+000, 0.00E+000, 0.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000},
		{0.00E+000, 0.00E+000, 0.00E+000, 0.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000},
		{0.00E+000, 0.00E+000, 0.00E+000, 0.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000},
		{0.00E+000, 0.00E+000, 0.00E+000, 0.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000},
		{0.00E+000, 0.00E+000, 0.00E+000, 0.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000},
		{0.00E+000, 0.00E+000, 0.00E+000, 0.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000},
		{0.00E+000, 0.00E+000, 0.00E+000, 0.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000},
		{0.00E+000, 0.00E+000, 0.00E+000, 0.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000},
		{0.00E+000, 0.00E+000, 0.00E+000, 0.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000},
		{0.00E+000, 0.00E+000, 0.00E+000, 0.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000},
		{0.00E+000, 0.00E+000, 0.00E+000, 0.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000},
		{0.00E+000, 0.00E+000, 0.00E+000, 0.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000},
		{0.00E+000, 0.00E+000, 0.00E+000, 0.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000},
		{0.00E+000, 0.00E+000, 0.00E+000, 0.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000},
		{0.00E+000, 0.00E+000, 0.00E+000, 0.00E+000, 9.99E-001, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000},
		{0.00E+000, 0.00E+000, 0.00E+000, 0.00E+000, 9.99E-001, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000},
		{0.00E+000, 0.00E+000, 0.00E+000, 0.00E+000, 9.98E-001, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000},
		{0.00E+000, 0.00E+000, 0.00E+000, 0.00E+000, 9.97E-001, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000},
		{0.00E+000, 0.00E+000, 0.00E+000, 0.00E+000, 9.95E-001, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000},
		{0.00E+000, 0.00E+000, 0.00E+000, 0.00E+000, 9.92E-001, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000},
		{0.00E+000, 0.00E+000, 0.00E+000, 0.00E+000, 9.87E-001, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000},
		{0.00E+000, 0.00E+000, 0.00E+000, 0.00E+000, 9.80E-001, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000},
		{0.00E+000, 0.00E+000, 0.00E+000, 0.00E+000, 9.71E-001, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000},
		{0.00E+000, 0.00E+000, 0.00E+000, 0.00E+000, 9.58E-001, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000},
		{0.00E+000, 0.00E+000, 0.00E+000, 0.00E+000, 9.40E-001, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000},
		{0.00E+000, 0.00E+000, 0.00E+000, 0.00E+000, 9.18E-001, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000},
		{0.00E+000, 0.00E+000, 0.00E+000, 0.00E+000, 8.90E-001, 9.99E-001, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000},
		{0.00E+000, 0.00E+000, 0.00E+000, 0.00E+000, 8.55E-001, 9.99E-001, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000},
		{0.00E+000, 0.00E+000, 0.00E+000, 0.00E+000, 8.14E-001, 9.98E-001, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000},
		{0.00E+000, 0.00E+000, 0.00E+000, 0.00E+000, 7.67E-001, 9.96E-001, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000},
		{0.00E+000, 0.00E+000, 0.00E+000, 0.00E+000, 7.13E-001, 9.93E-001, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000},
		{0.00E+000, 0.00E+000, 0.00E+000, 0.00E+000, 6.54E-001, 9.87E-001, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000},
		{0.00E+000, 0.00E+000, 0.00E+000, 0.00E+000, 5.91E-001, 9.78E-001, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000},
		{0.00E+000, 0.00E+000, 0.00E+000, 0.00E+000, 5.25E-001, 9.64E-001, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000},
		{0.00E+000, 0.00E+000, 0.00E+000, 0.00E+000, 4.59E-001, 9.44E-001, 9.99E-001, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000},
		{0.00E+000, 0.00E+000, 0.00E+000, 0.00E+000, 3.94E-001, 9.16E-001, 9.99E-001, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000},
		{0.00E+000, 0.00E+000, 0.00E+000, 0.00E+000, 3.32E-001, 8.79E-001, 9.97E-001, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000},
		{0.00E+000, 0.00E+000, 0.00E+000, 0.00E+000, 2.74E-001, 8.31E-001, 9.94E-001, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000},
		{0.00E+000, 0.00E+000, 0.00E+000, 0.00E+000, 2.22E-001, 7.72E-001, 9.87E-001, 9.99E-001, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000},
		{0.00E+000, 0.00E+000, 0.00E+000, 0.00E+000, 1.75E-001, 7.03E-001, 9.77E-001, 9.98E-001, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000},
		{0.00E+000, 0.00E+000, 0.00E+000, 0.00E+000, 1.36E-001, 6.26E-001, 9.59E-001, 9.95E-001, 9.99E-001, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000},
		{0.00E+000, 0.00E+000, 0.00E+000, 0.00E+000, 1.03E-001, 5.44E-001, 9.32E-001, 9.90E-001, 9.98E-001, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000},
		{0.00E+000, 0.00E+000, 0.00E+000, 0.00E+000, 7.63E-002, 4.60E-001, 8.92E-001, 9.80E-001, 9.96E-001, 9.99E-001, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000},
		{0.00E+000, 0.00E+000, 0.00E+000, 0.00E+000, 5.52E-002, 3.77E-001, 8.39E-001, 9.63E-001, 9.91E-001, 9.97E-001, 9.99E-001, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000},
		{0.00E+000, 0.00E+000, 0.00E+000, 0.00E+000, 3.90E-002, 3.00E-001, 7.70E-001, 9.35E-001, 9.80E-001, 9.92E-001, 9.97E-001, 9.99E-001, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000},
		{0.00E+000, 0.00E+000, 0.00E+000, 0.00E+000, 2.69E-002, 2.31E-001, 6.88E-001, 8.92E-001, 9.62E-001, 9.83E-001, 9.93E-001, 9.97E-001, 9.99E-001, 9.99E-001, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000},
		{0.00E+000, 0.00E+000, 0.00E+000, 0.00E+000, 1.81E-002, 1.72E-001, 5.95E-001, 8.33E-001, 9.31E-001, 9.66E-001, 9.85E-001, 9.93E-001, 9.96E-001, 9.98E-001, 9.99E-001, 9.99E-001, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000},
		{0.00E+000, 0.00E+000, 0.00E+000, 0.00E+000, 1.19E-002, 1.23E-001, 4.96E-001, 7.55E-001, 8.84E-001, 9.37E-001, 9.68E-001, 9.83E-001, 9.90E-001, 9.95E-001, 9.97E-001, 9.98E-001, 9.99E-001, 9.99E-001, 9.99E-001, 1.00E+000},
		{0.00E+000, 0.00E+000, 0.00E+000, 0.00E+000, 7.62E-003, 8.54E-002, 3.98E-001, 6.62E-001, 8.17E-001, 8.90E-001, 9.38E-001, 9.65E-001, 9.78E-001, 9.87E-001, 9.92E-001, 9.95E-001, 9.97E-001, 9.97E-001, 9.98E-001, 9.99E-001},
		{0.00E+000, 0.00E+000, 0.00E+000, 0.00E+000, 4.76E-003, 5.69E-002, 3.06E-001, 5.58E-001, 7.31E-001, 8.24E-001, 8.90E-001, 9.32E-001, 9.54E-001, 9.72E-001, 9.80E-001, 9.86E-001, 9.91E-001, 9.92E-001, 9.95E-001, 9.96E-001},
		{0.00E+000, 0.00E+000, 0.00E+000, 0.00E+000, 2.90E-003, 3.65E-002, 2.24E-001, 4.49E-001, 6.28E-001, 7.36E-001, 8.20E-001, 8.79E-001, 9.13E-001, 9.42E-001, 9.57E-001, 9.69E-001, 9.78E-001, 9.81E-001, 9.87E-001, 9.89E-001},
		{0.00E+000, 0.00E+000, 0.00E+000, 0.00E+000, 1.72E-003, 2.25E-002, 1.57E-001, 3.45E-001, 5.16E-001, 6.29E-001, 7.28E-001, 8.03E-001, 8.50E-001, 8.92E-001, 9.16E-001, 9.36E-001, 9.51E-001, 9.58E-001, 9.69E-001, 9.74E-001},
		{0.00E+000, 0.00E+000, 0.00E+000, 0.00E+000, 9.98E-004, 1.33E-002, 1.04E-001, 2.50E-001, 4.01E-001, 5.12E-001, 6.16E-001, 7.03E-001, 7.62E-001, 8.17E-001, 8.51E-001, 8.80E-001, 9.05E-001, 9.17E-001, 9.35E-001, 9.43E-001},
		{0.00E+000, 0.00E+000, 0.00E+000, 0.00E+000, 5.63E-004, 7.60E-003, 6.60E-002, 1.72E-001, 2.95E-001, 3.94E-001, 4.93E-001, 5.85E-001, 6.51E-001, 7.15E-001, 7.59E-001, 7.97E-001, 8.31E-001, 8.50E-001, 8.77E-001, 8.90E-001},
		{0.00E+000, 0.00E+000, 0.00E+000, 0.00E+000, 3.10E-004, 4.16E-003, 3.96E-002, 1.11E-001, 2.04E-001, 2.85E-001, 3.71E-001, 4.58E-001, 5.25E-001, 5.93E-001, 6.42E-001, 6.87E-001, 7.29E-001, 7.54E-001, 7.89E-001, 8.09E-001},
		{0.00E+000, 0.00E+000, 0.00E+000, 0.00E+000, 1.66E-004, 2.18E-003, 2.25E-002, 6.79E-002, 1.32E-001, 1.93E-001, 2.61E-001, 3.35E-001, 3.97E-001, 4.61E-001, 5.10E-001, 5.57E-001, 6.03E-001, 6.32E-001, 6.73E-001, 6.98E-001},
		{0.00E+000, 0.00E+000, 0.00E+000, 0.00E+000, 8.67E-005, 1.10E-003, 1.21E-002, 3.88E-002, 8.01E-002, 1.22E-001, 1.71E-001, 2.28E-001, 2.79E-001, 3.33E-001, 3.77E-001, 4.21E-001, 4.65E-001, 4.95E-001, 5.38E-001, 5.66E-001},
		{0.00E+000, 0.00E+000, 0.00E+000, 0.00E+000, 4.41E-005, 5.31E-004, 6.13E-003, 2.08E-002, 4.52E-002, 7.13E-002, 1.04E-001, 1.43E-001, 1.82E-001, 2.22E-001, 2.57E-001, 2.93E-001, 3.31E-001, 3.59E-001, 3.97E-001, 4.25E-001},
		{0.00E+000, 0.00E+000, 0.00E+000, 0.00E+000, 2.19E-005, 2.46E-004, 2.94E-003, 1.04E-002, 2.37E-002, 3.87E-002, 5.79E-002, 8.30E-002, 1.09E-001, 1.36E-001, 1.61E-001, 1.87E-001, 2.16E-001, 2.39E-001, 2.69E-001, 2.93E-001},
		{0.00E+000, 0.00E+000, 0.00E+000, 0.00E+000, 1.06E-005, 1.09E-004, 1.33E-003, 4.89E-003, 1.16E-002, 1.95E-002, 2.98E-002, 4.41E-002, 5.97E-002, 7.60E-002, 9.18E-002, 1.09E-001, 1.28E-001, 1.45E-001, 1.66E-001, 1.84E-001},
		{0.00E+000, 0.00E+000, 0.00E+000, 0.00E+000, 4.96E-006, 4.66E-005, 5.71E-004, 2.14E-003, 5.24E-003, 9.03E-003, 1.41E-002, 2.15E-002, 2.99E-002, 3.87E-002, 4.76E-002, 5.76E-002, 6.88E-002, 7.95E-002, 9.27E-002, 1.05E-001},
		{0.00E+000, 0.00E+000, 0.00E+000, 0.00E+000, 2.27E-006, 1.90E-005, 2.31E-004, 8.76E-004, 2.20E-003, 3.87E-003, 6.10E-003, 9.54E-003, 1.37E-002, 1.79E-002, 2.24E-002, 2.75E-002, 3.33E-002, 3.94E-002, 4.66E-002, 5.39E-002},
		{0.00E+000, 0.00E+000, 0.00E+000, 0.00E+000, 1.01E-006, 7.43E-006, 8.77E-005, 3.34E-004, 8.54E-004, 1.52E-003, 2.42E-003, 3.86E-003, 5.71E-003, 7.48E-003, 9.50E-003, 1.18E-002, 1.45E-002, 1.76E-002, 2.10E-002, 2.48E-002},
		{0.00E+000, 0.00E+000, 0.00E+000, 0.00E+000, 4.40E-007, 2.78E-006, 3.15E-005, 1.19E-004, 3.07E-004, 5.52E-004, 8.78E-004, 1.43E-003, 2.16E-003, 2.83E-003, 3.64E-003, 4.58E-003, 5.67E-003, 7.03E-003, 8.46E-003, 1.02E-002},
		{0.00E+000, 0.00E+000, 0.00E+000, 0.00E+000, 1.86E-007, 9.98E-007, 1.06E-005, 3.94E-005, 1.02E-004, 1.84E-004, 2.91E-004, 4.78E-004, 7.41E-004, 9.65E-004, 1.25E-003, 1.59E-003, 1.98E-003, 2.52E-003, 3.04E-003, 3.77E-003},
		{0.00E+000, 0.00E+000, 0.00E+000, 0.00E+000, 7.65E-008, 3.43E-007, 3.39E-006, 1.22E-005, 3.13E-005, 5.64E-005, 8.81E-005, 1.46E-004, 2.31E-004, 2.97E-004, 3.88E-004, 4.95E-004, 6.18E-004, 8.05E-004, 9.75E-004, 1.24E-003},
		{0.00E+000, 0.00E+000, 0.00E+000, 0.00E+000, 3.07E-008, 1.13E-007, 1.02E-006, 3.50E-006, 8.87E-006, 1.59E-005, 2.43E-005, 4.03E-005, 6.50E-005, 8.23E-005, 1.08E-004, 1.38E-004, 1.72E-004, 2.30E-004, 2.78E-004, 3.60E-004},
		{0.00E+000, 0.00E+000, 0.00E+000, 0.00E+000, 1.20E-008, 3.55E-008, 2.87E-007, 9.36E-007, 2.32E-006, 4.10E-006, 6.12E-006, 1.01E-005, 1.66E-005, 2.05E-005, 2.69E-005, 3.43E-005, 4.28E-005, 5.85E-005, 7.04E-005, 9.34E-005},
		{0.00E+000, 0.00E+000, 0.00E+000, 0.00E+000, 4.55E-009, 1.07E-008, 7.64E-008, 2.33E-007, 5.61E-007, 9.70E-007, 1.40E-006, 2.30E-006, 3.82E-006, 4.60E-006, 6.01E-006, 7.64E-006, 9.45E-006, 1.33E-005, 1.58E-005, 2.15E-005},
		{0.00E+000, 0.00E+000, 0.00E+000, 0.00E+000, 1.68E-009, 3.10E-009, 1.91E-008, 5.40E-008, 1.25E-007, 2.11E-007, 2.93E-007, 4.76E-007, 7.97E-007, 9.27E-007, 1.20E-006, 1.52E-006, 1.86E-006, 2.68E-006, 3.15E-006, 4.38E-006},
		{0.00E+000, 0.00E+000, 0.00E+000, 0.00E+000, 6.05E-010, 8.57E-010, 4.51E-009, 1.16E-008, 2.57E-008, 4.20E-008, 5.58E-008, 8.89E-008, 1.50E-007, 1.68E-007, 2.16E-007, 2.69E-007, 3.25E-007, 4.80E-007, 5.56E-007, 7.93E-007}
};
	
	public CCLargeHouseWaistWall() {
		super("CUREE-Caltech: Large House Waist Wall", "CCLargeHouseWaistWall");
		setInitVars();
		ADF = 0.003;
		BDF = 0.218;
		//NIML = IML.length;
		//register(supportedTypes);
	}

	@Override
	/**
	 * See the general contract in CureeCaltechWoodFrame.
	 */
	protected double[] getDFArray() {
		return DF;
	}
	@Override
	/**
	 * See the general contract in CureeCaltechWoodFrame.
	 */
	protected double[] getCOVDFArray() {
		return COVDF;
	}

	public double[][] getDEMMatrix() {
		return DEM;
	}
}
