package org.opensha.sra.vulnerability.models.servlet;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.net.URL;
import java.net.URLConnection;
import java.util.HashMap;
import java.util.Set;

import org.opensha.sra.vulnerability.Vulnerability;

public class VulnerabilityServletAccessor {
	
	public VulnerabilityServletAccessor() {
		
	}
	
	public HashMap<String, Vulnerability> getVulnMap() throws IOException {
		Object obj = getResult(null);
		if (obj == null)
			return null;
		return (HashMap<String, Vulnerability>)getResult(null);
	}
	
	public Vulnerability getVuln(String name) throws IOException {
		Object obj = getResult(name);
		if (obj == null)
			return null;
		return (Vulnerability)getResult(name);
	}
	
	public Set<String> getNames() throws IOException {
		Object obj = getResult(VulnerabilityServlet.VULN_LIST_NAME);
		if (obj == null)
			return null;
		return (Set<String>)obj;
	}
	
	private Object getResult(String name) throws IOException {
		URLConnection servletConnection = this.openServletConnection();
		
		ObjectOutputStream outputToServlet = new
				ObjectOutputStream(servletConnection.getOutputStream());
		
		outputToServlet.writeObject(name);
		
		ObjectInputStream inputFromServlet = new
		ObjectInputStream(servletConnection.getInputStream());
		
		try {
			Object result = inputFromServlet.readObject();
			
			inputFromServlet.close();
			
			return result;
		} catch (ClassNotFoundException e) {
			throw new RuntimeException(e);
		}
	}
	
	protected URLConnection openServletConnection() throws IOException {
		URL servlet = new URL(VulnerabilityServlet.SERVLET_URL);
//		System.out.println("Connecting to: " + url + " ...");
		URLConnection servletConnection = servlet.openConnection();
		
		// inform the connection that we will send output and accept input
		servletConnection.setDoInput(true);
		servletConnection.setDoOutput(true);

		// Don't use a cached version of URL connection.
		servletConnection.setUseCaches (false);
		servletConnection.setDefaultUseCaches (false);
		// Specify the content type that we will send binary data
		servletConnection.setRequestProperty ("Content-Type","application/octet-stream");
		
		return servletConnection;
	}
	
	public static void main(String args[]) throws IOException {
		VulnerabilityServletAccessor vulns = new VulnerabilityServletAccessor();
		
		Vulnerability vuln = vulns.getVuln("C1H-h-AGR1-DF");
		System.out.println("Got vuln:");
		System.out.println(vuln);
		
	}

}
