package org.opensha.sra.vulnerability.models.servlet;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.ArrayList;
import java.util.HashMap;

import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import org.opensha.commons.util.ServerPrefUtils;
import org.opensha.sra.vulnerability.Vulnerability;
import org.opensha.sra.vulnerability.models.SimpleVulnerability;
import org.opensha.sra.vulnerability.models.VulnFileReader;

public class VulnerabilityServlet extends HttpServlet {
	
	public static final String SERVLET_URL = ServerPrefUtils.SERVER_PREFS.getServletBaseURL() + "VulnerabilityServlet";
	
	protected static final String VULN_LIST_NAME = "GET_VULN_LIST";
	
	private static String debugName = "VulnServlet";
	
	private static final String vulnFileName = ServerPrefUtils.SERVER_PREFS.getDataDir().getAbsolutePath()
			+File.separator+"riskData"+File.separator+"vuln"+File.separator+"current";
	
	private HashMap<String, Vulnerability> vulnMap = new HashMap<String, Vulnerability>();
	
	public VulnerabilityServlet() throws IOException {
		ArrayList<SimpleVulnerability> vulns = VulnFileReader.readVUL06File(new FileInputStream(vulnFileName));
		for (SimpleVulnerability vuln : vulns) {
			vulnMap.put(vuln.getShortName(), vuln);
		}
	}
	
	//Process the HTTP Post request
	public void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
		// call the doGet method
		doGet(request,response);
	}
	
	// Process the HTTP Get request
	public void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
		// get an input stream from the applet
		ObjectInputStream in = new ObjectInputStream(request.getInputStream());
		ObjectOutputStream out = new ObjectOutputStream(response.getOutputStream());
		
		try {
			// this is the name. if null, all will be retrieved
			String name = (String)in.readObject();
			
			if (name == null) {
				debug("Sending entire vuln map");
				out.writeObject(vulnMap);
			} else if (name.equals(VULN_LIST_NAME)) {
				out.writeObject(vulnMap.keySet());
			} else {
				debug("Sending vuln: " + name);
				Vulnerability vuln = vulnMap.get(name);
				out.writeObject(vuln);
			}
			
			out.flush();
			out.close();
		} catch (Exception e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
			fail(out, "Servlet Exception: " + e.getMessage());
		}
	}
	
	protected void debug(String message) {
		ServerPrefUtils.debug(debugName, message);
	}
	
	protected void fail(ObjectOutputStream out, String message) throws IOException {
		ServerPrefUtils.fail(out, debugName, message);
	}
}
