package org.opensha.sra.gui.components;

import java.util.ArrayList;
import java.util.EventListener;
import java.util.List;

import javax.swing.JOptionPane;
import javax.swing.JPanel;

import org.opensha.commons.param.ParameterList;
import org.opensha.commons.param.constraint.impl.StringConstraint;
import org.opensha.commons.param.editor.impl.ConstrainedStringParameterEditor;
import org.opensha.commons.param.editor.impl.ParameterListEditor;
import org.opensha.commons.param.event.ParameterChangeEvent;
import org.opensha.commons.param.event.ParameterChangeFailEvent;
import org.opensha.commons.param.event.ParameterChangeFailListener;
import org.opensha.commons.param.event.ParameterChangeListener;
import org.opensha.commons.param.impl.StringParameter;

import org.opensha.sra.vulnerability.AbstractVulnerability;
import org.opensha.sra.vulnerability.models.curee.caltech.CCLargeHouseImmediateOccupancy;
import org.opensha.sra.vulnerability.models.curee.caltech.CCLargeHouseRigidDiaphram;
import org.opensha.sra.vulnerability.models.curee.caltech.CCLargeHouseTypical;
import org.opensha.sra.vulnerability.models.curee.caltech.CCLargeHouseWaistWall;
import org.opensha.sra.vulnerability.models.curee.caltech.CCSmallHouseRetro;
import org.opensha.sra.vulnerability.models.curee.caltech.CCSmallHouseTypical;
import org.opensha.sra.vulnerability.models.curee.caltech.CCTownhouseLimitedDrift;
import org.opensha.sra.vulnerability.models.curee.caltech.CCTownhouseTypical;

/**
 * <strong>Title:</strong> VulnerabilityBean<br />
 * <strong>Description:</strong> A bean to gather and store information about a vulnerabilty
 * model (function).
 * 
 * @author <a href="mailto:emartinez@usgs.gov">Eric Martinez</a>
 * @see VulnerabilityModel
 */
public class VulnerabilityBean implements GuiBeanAPI {
	private StringParameter vulnFilterParam;
	private static final String VULN_FILTER_PARAM_NAME = "Vuln. Model Filter";
	
	private StringParameter vulnParam = null;
	private static final String VULN_PARAM_NAME = "Vulnerability Model";
	
	List<AbstractVulnerability> vms;
	ArrayList<AbstractVulnerability> visibleVMs;
	private AbstractVulnerability vulnerability = null;
	private EventListener listener = null;
	
	private ParameterList paramList;
	private ParameterListEditor listEdit;
	
	////////////////////////////////////////////////////////////////////////////////
	//                              Public Functions                              //
	////////////////////////////////////////////////////////////////////////////////
	
	/**
	 * Creates a new <code>VulnerabilityBean</code> that is ready to be displayed by
	 * an application through a call to its <code>getVisualization(...)</code> method.
	 */
	public VulnerabilityBean(List<AbstractVulnerability> vms) {
		ArrayList<String> strings = new ArrayList<String>();
		// Add all the available vulnerabilities here
//		vms.add(new CCSmallHouseTypical());
//		vms.add(new CCSmallHouseRetro());
//		vms.add(new CCLargeHouseTypical());
//		vms.add(new CCLargeHouseWaistWall());
//		vms.add(new CCLargeHouseImmediateOccupancy());
//		vms.add(new CCLargeHouseRigidDiaphram());
//		vms.add(new CCTownhouseTypical());
//		vms.add(new CCTownhouseLimitedDrift()););
//		vms.add(new CCSmallHouseRetro());
//		vms.add(new CCLargeHouseTypical());
//		vms.add(new CCLargeHouseWaistWall());
//		vms.add(new CCLargeHouseImmediateOccupancy());
//		vms.add(new CCLargeHouseRigidDiaphram());
//		vms.add(new CCTownhouseTypical());
//		vms.add(new CCTownhouseLimitedDrift());
		this.vms = vms;
		visibleVMs = new ArrayList<AbstractVulnerability>();
		for(int i = 0; i < vms.size(); ++i) {
			strings.add(vms.get(i).getName());
			visibleVMs.add(vms.get(i));
		}
		vulnerability = vms.get(0);
		listener = new VulnerabilityParameterListener();
		
		vulnFilterParam = new StringParameter(VULN_FILTER_PARAM_NAME);
		vulnFilterParam.setValue("");
		vulnFilterParam.addParameterChangeListener((ParameterChangeListener) listener);
		
		vulnParam = new StringParameter(VULN_PARAM_NAME, strings, strings.get(0));
		vulnParam.setInfo("The facility or facility class representing the building conditions");
		vulnParam.addParameterChangeListener((ParameterChangeListener) listener);
		vulnParam.addParameterChangeFailListener((ParameterChangeFailListener) listener);
		
		paramList = new ParameterList();
		paramList.addParameter(vulnFilterParam);
		paramList.addParameter(vulnParam);
		listEdit = new ParameterListEditor(paramList);
	}
	
	/** @return The currently selected vulnerability model */
	public AbstractVulnerability getCurrentModel() { return vulnerability; }
	/** @return The underlying parameters associated with this bean */
	public StringParameter getParameter() { return vulnParam;}
	
	public ParameterList getDisplayParameters() { return paramList; }
	
	////////////////////////////////////////////////////////////////////////////////
	//                Minimum Functions to Implement GuiBeanAPI                   //
	////////////////////////////////////////////////////////////////////////////////
	
	/**
	 * See the general contract in GuiBeanAPI.
	 */
	public Object getVisualization(int type) {
		if(!isVisualizationSupported(type))
			throw new IllegalArgumentException("Only the Application type is supported at this time.");
		if(type == GuiBeanAPI.APPLICATION) {
			return getApplicationVisualization();
		}
		return null;
	}

	/**
	 * See the general contract in GuiBeanAPI.
	 */
	public String getVisualizationClassName(int type) {
		String cname = null;
		if(type == GuiBeanAPI.APPLICATION) {
			cname = "javax.swing.JPanel";
		}
		
		return cname;
	}

	/**
	 * See the general contract in GuiBeanAPI.
	 */
	public boolean isVisualizationSupported(int type) {
		return type == GuiBeanAPI.APPLICATION;
	}

	////////////////////////////////////////////////////////////////////////////////
	//                             Private Functions                              //
	////////////////////////////////////////////////////////////////////////////////
	
	private JPanel getApplicationVisualization() {
		return listEdit;
	}
	
	private void updateFilter(String filter) {
		ArrayList<String> strings = new ArrayList<String>();
		visibleVMs.clear();
		
		filter = filter.toLowerCase();
		
		for (AbstractVulnerability vm : vms) {
			String name = vm.getName();
			if (filter == null || name.toLowerCase().contains(filter)) {
				visibleVMs.add(vm);
				strings.add(name);
			}
		}
		
		((StringConstraint)vulnParam.getConstraint()).setStrings(strings);
		vulnParam.setValue(strings.get(0));
		vulnParam.getEditor().refreshParamEditor();
	}
	
	private void handleVulnerabilityChange(ParameterChangeEvent event) {
		String newVuln = (String) event.getNewValue();
		for(int i = 0; i < visibleVMs.size(); ++i ) {
			if(newVuln.equals(visibleVMs.get(i).getName())) {
				vulnerability = visibleVMs.get(i);
				break;
			}
		}
	}
	private class VulnerabilityParameterListener implements ParameterChangeListener, ParameterChangeFailListener {

		public void parameterChange(ParameterChangeEvent event) {
			if (VULN_PARAM_NAME.equals(event.getParameterName()))
				handleVulnerabilityChange(event);
			else if (VULN_FILTER_PARAM_NAME.equals(event.getParameterName()))
				updateFilter(vulnFilterParam.getValue());
		}

		public void parameterChangeFailed(ParameterChangeFailEvent event) {
			JOptionPane.showMessageDialog(null, "The input value of " + event.getBadValue() +
					" is out of range.", "Failed to Change Value", JOptionPane.ERROR_MESSAGE);
		}
		
	}
}