package org.opensha.sha.imr.param.IntensityMeasureParams;

import org.opensha.commons.param.constraint.impl.DoubleConstraint;
import org.opensha.commons.param.impl.WarningDoubleParameter;

/**
 * This constitutes the natural-log Arias Intensity intensity measure
 * parameter.  
 * See constructors for info on editability and default values.
 * @author goulet (aug 2009) - modified based on PGA_Param from field
 *
 */
public class IA_Param extends WarningDoubleParameter {

    public final static String NAME = "IA"; 
    public final static String UNITS = "m/s"; 
    public final static String INFO = "Arias Intensity"; 
    public final static Double MIN = Double.valueOf(Math.log(Double.MIN_VALUE)); 
    public final static Double MAX = Double.valueOf(Double.MAX_VALUE); 
    public final static Double DEFAULT_WARN_MIN = Double.valueOf(Math.log(Double.MIN_VALUE)); 
    public final static Double DEFAULT_WARN_MAX = Double.valueOf(Double.MAX_VALUE); 


	/**
	 * This uses the supplied warning constraint and default (both in natural-log space).
	 * The parameter is left as non editable
	 * @param warningConstraint
	 * @param defaultPGA
	 */
	public IA_Param(DoubleConstraint warningConstraint, double defaultIA) {
		super(NAME, new DoubleConstraint(MIN, MAX), UNITS);
		getConstraint().setNonEditable();
	    this.setInfo(INFO);
	    setWarningConstraint(warningConstraint);
	    setDefaultValue(defaultIA);
	    setNonEditable();
	}
	
	/**
	 * This uses the DEFAULT_WARN_MIN and DEFAULT_WARN_MAX fields to set the
	 * warning constraint, and sets the default as Math.log(1.0) (the natural
	 * log of 1.0).
	 * The parameter is left as non editable
	 */
	public IA_Param() {
		super(NAME, new DoubleConstraint(MIN, MAX), UNITS);
		getConstraint().setNonEditable();
	    setInfo(INFO);
	    DoubleConstraint warn2 = new DoubleConstraint(DEFAULT_WARN_MIN, DEFAULT_WARN_MAX);
	    warn2.setNonEditable();
	    setWarningConstraint(warn2);
	    setDefaultValue(Math.log(1.0));
	    setNonEditable();
	}
}
