package org.opensha.sha.earthquake.griddedForecast;

import java.util.ArrayList;
import java.util.EventObject;
import java.util.ListIterator;

import org.opensha.commons.data.TimeSpan;
import org.opensha.commons.geo.GriddedRegion;
import org.opensha.commons.geo.Location;
import org.opensha.commons.geo.Region;
import org.opensha.commons.param.ParameterList;
import org.opensha.commons.param.event.ParameterChangeEvent;
import org.opensha.commons.param.event.ParameterChangeListener;
import org.opensha.sha.earthquake.AbstractERF;
import org.opensha.sha.earthquake.BaseERF;
import org.opensha.sha.util.TectonicRegionType;

/**
 * <p>
 * Title: GriddedHypoMagFreqForecast
 * </p>
 * 
 * <p>
 * Description: This constitutes a Poissonian hypocenter forecast.
 * 
 * Are locations unique?.
 * </p>
 *<p>
 * Note : The rate provided by this forecast are always yearly rate.
 *</p>
 * 
 * @author Nitin Gupta , Edward (Ned) Field, Vipin Gupta
 * @version 1.0
 */
public abstract class GriddedHypoMagFreqDistForecast implements
BaseERF,
HypoMagFreqDistAtMultLocsAPI,
ParameterChangeListener {

	// TODO why abstract? no abstract methods; just lacks constructoirs

	// Timespan for the given forecast
	private TimeSpan timeSpan;
	// number of hypocenter location.
	// private int numHypoLocation;
	// Adjustable parameters fro the given forecast model
	private ParameterList adjustableParameters;
	// Only update the forecast if parameters have been changed.
	protected boolean parameterChangeFlag = true;

	// EvenlyGriddedGeographicAPI region
	protected GriddedRegion region;

	private ArrayList listenerList = new ArrayList();

	/**
	 * Gets the EvenlyGriddedGeographic Region
	 * 
	 * @return EvenlyGriddedGeographicRegionAPI
	 */
	public GriddedRegion getRegion() {
		return region;
	}

	public void setRegion(GriddedRegion region) {
		this.region = region;
	}

	/**
	 * Get the region for which this forecast is applicable
	 * @return : Geographic region object specifying the applicable region of forecast
	 */
	public Region getApplicableRegion() {
		return region;
	}

	/**
	 * Returns the adjustable parameters list
	 * 
	 * @return ParameterList
	 */
	public ParameterList getAdjustableParameterList() {
		return adjustableParameters;
	}

	/**
	 * Returns the adjustable parameters as the ListIterator
	 * 
	 * @return ListIterator
	 */
	public ListIterator getAdjustableParamsIterator() {
		return adjustableParameters.getParametersIterator();
	}

	/**
	 * Return the name for this class
	 * 
	 * @return : return the name for this class
	 */
	public String getName() {
		return null;
	}

	/**
	 * Update and save the serialized forecast into the file
	 */
	public String updateAndSaveForecast() {
		throw new UnsupportedOperationException(
		"updateAndSaveForecast() not supported");
	}

	/**
	 * getNumHypoLocation
	 * 
	 * @return int
	 * @todo Implement this org.opensha.sha.earthquake.HypoMagFreqDistAtLocAPI
	 *       method
	 */
	public int getNumHypoLocs() {
		return region.getNodeCount();
	}

	/**
	 * Function that must be implemented by all Timespan Listeners for
	 * ParameterChangeEvents.
	 * 
	 * @param event The Event which triggered this function call
	 */
	public void timeSpanChange(EventObject event) {
		this.parameterChangeFlag = true;
	}

	/**
	 * This is the main function of this interface. Any time a control paramater
	 * or independent paramater is changed by the user in a GUI this function is
	 * called, and a paramater change event is passed in.
	 * 
	 * This sets the flag to indicate that the sources need to be updated
	 * 
	 * @param event
	 */
	public void parameterChange(ParameterChangeEvent event) {
		parameterChangeFlag = true;
	}

	/**
	 * Allows the user to get the Timespan for this
	 * GriddedHypoMagFreqDistForecast
	 * 
	 * @return TimeSpan
	 */
	public TimeSpan getTimeSpan() {
		return timeSpan;
	}

	public void setParameter(String name, Object value) {
		AbstractERF.setParameter(this, name, value);
	}

	/**
	 * Allows the user to set the Timespan for this
	 * GriddedHypoMagFreqDistForecast
	 * 
	 * @param timeSpan TimeSpan
	 */
	public void setTimeSpan(TimeSpan timeSpan) {
		this.timeSpan = timeSpan;
	}

	/**
	 * If any parameter has been changed then update the forecast. NOTE : Not
	 * implemented
	 */
	public void updateForecast() {
		if (parameterChangeFlag) {

		}
	}

	/**
	 * This specifies what types of Tectonic Regions are included in the ERF.
	 * This default implementation includes only ACTIVE_SHALLOW, so it should 
	 * be overridden in subclasses if other types are used
	 * @return : ArrayList<TectonicRegionType>
	 */
	public ArrayList<TectonicRegionType> getIncludedTectonicRegionTypes(){
		ArrayList<TectonicRegionType> list = new ArrayList<TectonicRegionType>();
		list.add(TectonicRegionType.ACTIVE_SHALLOW);
		return list;
	}

	@Override
	public int compareTo(BaseERF o) {
		return getName().compareToIgnoreCase(o.getName());
	}

}
